import pickle
import numpy as np
import pandas as pd

def compare_dataframes(df_origin, df_1, df_2):
    if not (df_1.index.equals(df_2.index)):
        return false

    if all(col in df_origin.columns for col in df_1.columns):
        if set(df_1.columns) != set(df_2.columns):
            return false
        for col in df_1.columns:
            df_2_col = df_2[col] if col in df_2.columns else df_2[df_1.columns[df_1.columns == col][0]]
            if df_1[col].dtype.kind in 'ifc' and df_2_col.dtype.kind in 'ifc':
                if not np.allclose(df_1[col], df_2_col, equal_nan=true):
                    return false
            elif not df_1[col].equals(df_2_col):
                return false
    else:
        for col in df_1.columns:
            if col not in df_origin.columns:
                found_match = false
                for df_2_col in df_2.columns:
                    if df_1[col].dtype.kind in 'ifc' and df_2[df_2_col].dtype.kind in 'ifc':
                        if np.allclose(df_1[col], df_2[df_2_col], equal_nan=true):
                            found_match = true
                            break
                    elif df_1[col].dtype == df_2[df_2_col].dtype:
                        if df_1[col].equals(df_2[df_2_col]):
                            found_match = true
                            break
                if not found_match:
                    return false

    return true

# replace <ai_res> and <ref_res> with the actual ai and reference outputs
try:
    with open("pred_result/clients_25_to_55.pkl", "rb") as fp:
        machine_result = pickle.load(fp)
except:
        machine_result = none

with open("ref_result/clients_25_to_55.pkl", "rb") as fr:
    reference_result = pickle.load(fr)

df_origin = pd.read_csv("YOUR_DIR/tapilot_data/all_data_v2/credit_customers.csv")
   
try:
    result = compare_dataframes(df_origin, machine_result, reference_result)
except:
    result = false

print(result)